<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Events\V1\Subscription;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class SubscribedEventOptions {
    /**
     * @param int $version The version
     * @return CreateSubscribedEventOptions Options builder
     */
    public static function create(int $version = Values::NONE): CreateSubscribedEventOptions {
        return new CreateSubscribedEventOptions($version);
    }
}

class CreateSubscribedEventOptions extends Options {
    /**
     * @param int $version The version
     */
    public function __construct(int $version = Values::NONE) {
        $this->options['version'] = $version;
    }

    /**
     * The version
     *
     * @param int $version The version
     * @return $this Fluent Builder
     */
    public function setVersion(int $version): self {
        $this->options['version'] = $version;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Events.V1.CreateSubscribedEventOptions ' . $options . ']';
    }
}