<?php
namespace org\apache\maven\POM\_4_0_0;

/**
 * @xmlNamespace http://maven.apache.org/POM/4.0.0
 * @xmlType
 * @xmlName DistributionManagement
 * @var org\apache\maven\POM\_4_0_0\DistributionManagement
 * @xmlDefinition
                This elements describes all that pertains to distribution for a project.
                It is primarily used for deployment of artifacts and the site
                produced by the build.

 */
class DistributionManagement
{

    
    /**
     * @Definition
                        Information needed to deploy the artifacts generated by the project to a remote
                        repository.

     * @xmlType element
     * @xmlNamespace http://maven.apache.org/POM/4.0.0
     * @xmlMinOccurs 0
     * @xmlName repository
     * @var org\apache\maven\POM\_4_0_0\DeploymentRepository
     */
    public $repository;
    /**
     * @Definition
                        Where to deploy snapshots of artifacts to. If not given, it defaults to the
                        <code>repository</code> element.

     * @xmlType element
     * @xmlNamespace http://maven.apache.org/POM/4.0.0
     * @xmlMinOccurs 0
     * @xmlName snapshotRepository
     * @var org\apache\maven\POM\_4_0_0\DeploymentRepository
     */
    public $snapshotRepository;
    /**
     * @Definition
                        Information needed for deploying the web site of the project.

     * @xmlType element
     * @xmlNamespace http://maven.apache.org/POM/4.0.0
     * @xmlMinOccurs 0
     * @xmlName site
     * @var org\apache\maven\POM\_4_0_0\Site
     */
    public $site;
    /**
     * @Definition
                        The URL of the project's download page. If not given users will be
                        referred to the homepage given by
                        <code>url</code>. This is given to assist in locating artifacts that are not in the
                        repository due to
                        licensing restrictions.

     * @xmlType element
     * @xmlNamespace http://maven.apache.org/POM/4.0.0
     * @xmlMinOccurs 0
     * @xmlName downloadUrl
     * @var string
     */
    public $downloadUrl;
    /**
     * @Definition
                        Relocation information of the artifact if it has been moved to a new group ID and/or
                        artifact ID.

     * @xmlType element
     * @xmlNamespace http://maven.apache.org/POM/4.0.0
     * @xmlMinOccurs 0
     * @xmlName relocation
     * @var org\apache\maven\POM\_4_0_0\Relocation
     */
    public $relocation;
    /**
     * @Definition
                        Gives the status of this artifact in the remote repository. This must not be
                        set in your local
                        project, as it is updated by tools placing it in the reposiory. Valid values are:
                        <code>none</code> (default),
                        <code>converted</code> (repository manager converted this from
                        an Maven 1 POM), <code>partner</code>
                        (directly synced from a partner Maven 2 repository),
                        <code>deployed</code> (was deployed from a Maven 2
                        instance), <code>verified</code> (has been hand verified as correct and
                        final).

     * @xmlType element
     * @xmlNamespace http://maven.apache.org/POM/4.0.0
     * @xmlMinOccurs 0
     * @xmlName status
     * @var string
     */
    public $status;
} // end class DistributionManagement
